/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalinnovation.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.ItemMulti;
import cofh.core.item.ItemMultiRF;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RayTracer;
import cofh.core.util.core.IInitializer;
import cofh.core.util.filter.ItemFilterWrapper;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.init.TFSounds;
import cofh.thermalinnovation.ThermalInnovation;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemMagnet
extends ItemMultiRF
implements IInitializer,
IBauble {
    private static Int2ObjectOpenHashMap<TypeEntry> typeMap = new Int2ObjectOpenHashMap();
    public static final int CAPACITY_BASE = 40000;
    public static final int XFER_BASE = 1000;
    public static final int ENERGY_PER_ITEM = 25;
    public static final int ENERGY_PER_USE = 250;
    public static final int[] CAPACITY = new int[]{1, 3, 6, 10, 15};
    public static final int[] XFER = new int[]{1, 4, 9, 16, 25};
    public static boolean enable = true;
    public static ItemStack magnetBasic;
    public static ItemStack magnetHardened;
    public static ItemStack magnetReinforced;
    public static ItemStack magnetSignalum;
    public static ItemStack magnetResonant;
    public static ItemStack magnetCreative;

    public ItemMagnet() {
        super("thermalinnovation");
        this.func_77655_b("magnet");
        this.func_77637_a(ThermalInnovation.tabTools);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        int radius = this.getRadius(stack);
        tooltip.add(StringHelper.getInfoText((String)"info.thermalinnovation.magnet.a.0"));
        tooltip.add(StringHelper.localize((String)"info.thermalinnovation.magnet.a.1"));
        tooltip.add(StringHelper.getNoticeText((String)"info.thermalinnovation.magnet.a.2"));
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalinnovation.magnet.b." + this.getMode(stack)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        tooltip.add("\u00a76" + StringHelper.localize((String)"info.cofh.radius") + ": " + radius + "\u00a7r");
        if (ItemMagnet.isCreative((ItemStack)stack)) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable && this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    if (TFProps.showEmptyItems) {
                        items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)0));
                    }
                    if (!TFProps.showFullItems) continue;
                    items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)this.getBaseCapacity(metadata)));
                    continue;
                }
                if (!TFProps.showCreativeItems) continue;
                items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)this.getBaseCapacity(metadata)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (!(entity instanceof EntityPlayer) || CoreUtils.isFakePlayer((Entity)entity) || entity.func_70093_af() || this.getMode(stack) <= 0) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.getEnergyStored(stack) < 25 && !player.field_71075_bZ.field_75098_d) {
            return;
        }
        int radius = this.getRadius(stack);
        int radSq = radius * radius;
        AxisAlignedBB area = new AxisAlignedBB(player.func_180425_c().func_177982_a(-radius, -radius, -radius), player.func_180425_c().func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List items = world.func_175647_a(EntityItem.class, area, EntitySelectors.field_94557_a);
        ItemFilterWrapper wrapper = new ItemFilterWrapper(stack, ItemMagnet.getFilterSize(stack));
        if (ServerHelper.isClientWorld((World)world)) {
            for (EntityItem item : items) {
                if (item.func_174874_s() || item.getEntityData().func_74767_n("PreventRemoteMovement") || !(item.func_174791_d().func_72436_e(player.func_174791_d()) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                world.func_175688_a(EnumParticleTypes.REDSTONE, item.field_70165_t, item.field_70163_u, item.field_70161_v, 0.0, 0.0, 0.0, new int[]{0});
            }
        } else {
            int itemCount = 0;
            for (EntityItem item : items) {
                if (item.func_174874_s() || item.getEntityData().func_74767_n("PreventRemoteMovement") || item.func_145800_j() != null && item.func_145800_j().equals(player.func_70005_c_()) && item.field_70292_b < 64 || !(item.func_174791_d().func_72436_e(player.func_174791_d()) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                item.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                item.func_174867_a(0);
                ++itemCount;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.extractEnergy(stack, 25 * itemCount, false);
            }
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return 10;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af()) {
            player.openGui((Object)ThermalInnovation.instance, 17, world, 0, 0, 0);
        } else if (this.getEnergyStored(stack) >= 250 || player.field_71075_bZ.field_75098_d) {
            RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (double)64.0);
            if (traceResult == null || traceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            int radius = this.getRadius(stack);
            int radSq = radius * radius;
            AxisAlignedBB area = new AxisAlignedBB(traceResult.func_178782_a().func_177982_a(-radius, -radius, -radius), traceResult.func_178782_a().func_177982_a(1 + radius, 1 + radius, 1 + radius));
            List items = world.func_175647_a(EntityItem.class, area, EntitySelectors.field_94557_a);
            ItemFilterWrapper wrapper = new ItemFilterWrapper(stack, ItemMagnet.getFilterSize(stack));
            if (ServerHelper.isClientWorld((World)world)) {
                for (EntityItem item : items) {
                    if (!(item.func_174791_d().func_72436_e(traceResult.field_72307_f) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                    world.func_175688_a(EnumParticleTypes.PORTAL, item.field_70165_t, item.field_70163_u, item.field_70161_v, 0.0, 0.0, 0.0, new int[]{0});
                }
            } else {
                int itemCount = 0;
                for (EntityItem item : items) {
                    if (!(item.func_174791_d().func_72436_e(traceResult.field_72307_f) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                    item.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    item.func_174867_a(0);
                    ++itemCount;
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.extractEnergy(stack, 250 + 25 * itemCount, false);
                }
            }
            player.func_184609_a(hand);
            stack.func_190915_d(5);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFSounds.magnetUse, SoundCategory.PLAYERS, 0.4f, 1.0f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    protected int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemMagnet.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    protected int getReceive(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemMagnet.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).recv;
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemMagnet.typeMap.get((int)metadata)).capacity;
    }

    public int getRadius(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemMagnet.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level + 4;
    }

    public static int getLevel(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        return ((TypeEntry)ItemMagnet.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public static int getFilterSize(ItemStack stack) {
        return CoreProps.FILTER_SIZE[ItemMagnet.getLevel(stack)];
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        World world = player.field_70170_p;
        if (world.func_82737_E() % 8L != 0L) {
            return;
        }
        if (!(player instanceof EntityPlayer) || CoreUtils.isFakePlayer((Entity)player) || player.func_70093_af() || this.getMode(stack) <= 0) {
            return;
        }
        EntityPlayer castPlayer = (EntityPlayer)player;
        if (this.getEnergyStored(stack) < 25 && !castPlayer.field_71075_bZ.field_75098_d) {
            return;
        }
        int radius = this.getRadius(stack);
        int radSq = radius * radius;
        AxisAlignedBB area = new AxisAlignedBB(player.func_180425_c().func_177982_a(-radius, -radius, -radius), player.func_180425_c().func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List items = world.func_175647_a(EntityItem.class, area, EntitySelectors.field_94557_a);
        ItemFilterWrapper wrapper = new ItemFilterWrapper(stack, ItemMagnet.getFilterSize(stack));
        if (ServerHelper.isClientWorld((World)world)) {
            for (EntityItem item : items) {
                if (item.getEntityData().func_74767_n("PreventRemoteMovement") || !(item.func_174791_d().func_72436_e(player.func_174791_d()) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                world.func_175688_a(EnumParticleTypes.REDSTONE, item.field_70165_t, item.field_70163_u, item.field_70161_v, 0.0, 0.0, 0.0, new int[]{0});
            }
        } else {
            int itemCount = 0;
            for (EntityItem item : items) {
                if (item.getEntityData().func_74767_n("PreventRemoteMovement") || item.func_145800_j() != null && item.func_145800_j().equals(player.func_70005_c_()) && item.field_70292_b < 64 || !(item.func_174791_d().func_72436_e(player.func_174791_d()) <= (double)radSq) || !wrapper.getFilter().matches(item.func_92059_d())) continue;
                item.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                item.func_174867_a(0);
                ++itemCount;
            }
            if (!castPlayer.field_71075_bZ.field_75098_d) {
                this.extractEnergy(stack, 25 * itemCount, false);
            }
        }
    }

    public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFSounds.magnetUse, SoundCategory.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.thermalinnovation.magnet.c." + this.getMode(stack), new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            Object[] objectArray = new Object[3];
            objectArray[0] = ColorHelper.hasColor0((ItemStack)stack) ? 1 : 0;
            objectArray[1] = this.getEnergyStored(stack) > 0 ? (this.getMode(stack) == 1 ? "active" : "charged") : "drained";
            objectArray[2] = ((TypeEntry)ItemMagnet.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).name;
            return new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,state=%s,type=%s", objectArray));
        });
        String[] states = new String[]{"charged", "active", "drained"};
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int color0 = 0; color0 < 2; ++color0) {
                for (int state = 0; state < 3; ++state) {
                    ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("color0=%s,state=%s,type=%s", color0, states[state], ((ItemMulti.ItemEntry)entry.getValue()).name))});
                }
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("magnet"));
        ThermalInnovation.proxy.addIModelRegister((IModelRegister)this);
        ItemMagnet.config();
        magnetBasic = this.addEntryItem(0, "standard0", 0, EnumRarity.COMMON);
        magnetHardened = this.addEntryItem(1, "standard1", 1, EnumRarity.COMMON);
        magnetReinforced = this.addEntryItem(2, "standard2", 2, EnumRarity.UNCOMMON);
        magnetSignalum = this.addEntryItem(3, "standard3", 3, EnumRarity.UNCOMMON);
        magnetResonant = this.addEntryItem(4, "standard4", 4, EnumRarity.RARE);
        magnetCreative = this.addEntryItem(32000, "creative", CAPACITY[4], 0, 4, EnumRarity.EPIC);
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        RecipeHelper.addShapedRecipe((ItemStack)magnetBasic, (Object[])new Object[]{"IRI", "XIX", " R ", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('X'), "ingotLead"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)magnetHardened, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotInvar", Character.valueOf('R'), "nuggetCopper", Character.valueOf('X'), magnetBasic});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)magnetReinforced, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotElectrum", Character.valueOf('R'), "nuggetInvar", Character.valueOf('X'), magnetHardened});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)magnetSignalum, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotSignalum", Character.valueOf('R'), "nuggetElectrum", Character.valueOf('X'), magnetReinforced});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)magnetResonant, (Object[])new Object[]{" R ", "IXI", "R R", Character.valueOf('I'), "ingotEnderium", Character.valueOf('R'), "nuggetSignalum", Character.valueOf('X'), magnetSignalum});
        RecipeHelper.addColorRecipe((ItemStack)magnetBasic, (Object[])new Object[]{magnetBasic, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)magnetHardened, (Object[])new Object[]{magnetHardened, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)magnetReinforced, (Object[])new Object[]{magnetReinforced, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)magnetSignalum, (Object[])new Object[]{magnetSignalum, "dye"});
        RecipeHelper.addColorRecipe((ItemStack)magnetResonant, (Object[])new Object[]{magnetResonant, "dye"});
        RecipeHelper.addColorRemoveRecipe((ItemStack)magnetBasic, (Object[])new Object[]{magnetBasic});
        RecipeHelper.addColorRemoveRecipe((ItemStack)magnetHardened, (Object[])new Object[]{magnetHardened});
        RecipeHelper.addColorRemoveRecipe((ItemStack)magnetReinforced, (Object[])new Object[]{magnetReinforced});
        RecipeHelper.addColorRemoveRecipe((ItemStack)magnetSignalum, (Object[])new Object[]{magnetSignalum});
        RecipeHelper.addColorRemoveRecipe((ItemStack)magnetResonant, (Object[])new Object[]{magnetResonant});
        return true;
    }

    private static void config() {
        String category = "Item.Magnet";
        enable = ThermalInnovation.CONFIG.get(category, "Enable", true);
        int capacity = 40000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Fluxomagnet. This base value will scale with item level.";
        capacity = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, 10000, 10000000, comment);
        int xfer = 1000;
        comment = "Adjust this value to change the amount of Energy (in RF/t) that can be received by a Basic Fluxomagnet. This base value will scale with item level.";
        xfer = ThermalInnovation.CONFIG.getConfiguration().getInt("BaseReceive", category, xfer, 100, 1000000, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i;
            CAPACITY[n] = CAPACITY[n] * capacity;
            int n2 = i++;
            XFER[n2] = XFER[n2] * xfer;
        }
    }

    private void addEntry(int metadata, String name, int capacity, int xfer, int level) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity, xfer, level));
    }

    private ItemStack addEntryItem(int metadata, String name, int level, EnumRarity rarity) {
        this.addEntry(metadata, name, CAPACITY[metadata], XFER[metadata], level);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int xfer, int radius, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity, xfer, radius);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;
        public final int recv;
        public final int level;

        TypeEntry(String name, int capacity, int recv, int level) {
            this.name = name;
            this.capacity = capacity;
            this.recv = recv;
            this.level = level;
        }
    }
}

